<?php

function sm_portfolio_carousel_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'portfolio-carousel', $view_params );
}

function sm_register_shortcode_handler_sm_portfolio_carousel() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_portfolio_carousel extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_portfolio_carousel_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_portfolio_carousel', 'sm_portfolio_carousel_func' );
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Portfolio Carousel', 'semona-extension' ),
	'base' => 'sm_portfolio_carousel',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-portfolio_carousel.png',
	'params' => array (
			array (
					'type' => 'textfield',
					'heading' => esc_html__( 'Number of Items to show', 'semona-extension' ),
					'param_name' => 'items_to_show',
					'value' => '',
					'description' => esc_html__( 'Leave empty for using default theme option value.', 'semona-extension' ) 
			),
			array (
					'type' => 'textfield',
					'heading' => esc_html__( 'Number of Items to show in screen', 'semona-extension' ),
					'param_name' => 'items_in_screen',
					'value' => '5',
			),
			array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Categories To Display', 'semona-extension' ),
					'param_name' => 'categories',
					'settings' => array(
							'multiple' => true,
							'min_length' => 1,
							'groups' => true,
							'unique_values' => true,
							'display_inline' => true,
							'delay' => 500,
							'auto_focus' => true,
					),
					'param_holder_class' => 'vc_not-for-custom',
					'description' => esc_html__( 'Enter post categories.', 'semona-extension' ),
			),
			sm_extra_class(), 
	)
) );

add_filter( 'vc_autocomplete_sm_portfolio_carousel_categories_render', 'sm_portfolio_carousel_categories_vc_autocomplete_render', 10, 1 );
function sm_portfolio_carousel_categories_vc_autocomplete_render( $term ) {
	$terms = get_terms(
			array( 'portfolio_category' ),
			array(
					'include' => array( $term['value'] ),
					'hide_empty' => false,
			)
	);
	$data = false;
	if ( is_array( $terms ) && 1 === count( $terms ) ) {
		$term = $terms[0];
		$data = array(
				'label' => $term->name,
				'value' => $term->term_id,
		);
	}

	return $data;
}

add_filter( 'vc_autocomplete_sm_portfolio_carousel_categories_callback', 'sm_portfolio_carousel_categories_vc_autocomplete_search', 10, 1 );
function sm_portfolio_carousel_categories_vc_autocomplete_search( $search_string ) {
	$data = array();
	$terms = get_terms(
			array( 'portfolio_category' ),
			array(
					'search' => $search_string,
					'hide_empty' => false,
			)
	);
	if ( is_array( $terms ) && ! empty( $terms ) ) {
		foreach ( $terms as $t ) {
			if ( is_object( $t ) ) {
				$data[] = array(
						'label' => $t->name,
						'value' => $t->term_id,
				);
			}
		}
	}

	return $data;
}